#!/usr/bin/perl -w

use ExtUtils::MakeMaker;

my @binscripts=qw(id3fs-index);
my @sbinscripts=qw(id3fsd);

WriteMakefile(NAME=>"id3fs",
	      VERSION=>"1.0",
	      EXE_FILES=>[ map( "bin/$_", @binscripts) ],
	      MAN1PODS=>{ map({ +"bin/$_" => "\${INST_MAN1DIR}/$_.1" } @binscripts) },
	      PREREQ_PM=>{ 'Fuse'                 => 0,
			   'DBI'                  => 0,
			   'DBD::SQLite'          => 0,
			   'MP3::Tag'             => 0,
			   'Audio::FLAC::Header'  => 0,
			   'Ogg::Vorbis::Header'  => 0,
	      } ,
	      ($] >= 5.005
	       ? (ABSTRACT   => 'FUSE-based filesystem for browsing music metadata',
		  AUTHOR     => 'Ian Beckwith <ianb@erislabs.net>')
	       : ()),
	      );

# man 5/8 stuff adapted from vipul's razor, http://razor.sf.net

{
package MY;

sub constants {

    my $self = shift;
    my $inherited = $self->SUPER::constants(@_);

    my $add = q{

# begin id3fs
MAN1EXT = 1
MAN8PODS = sbin/id3fsd
INST_MAN8DIR = blib/man8
INSTALLMAN8DIR = $(PERLPREFIX)/share/man/man8
DESTINSTALLMAN8DIR = $(DESTDIR)$(INSTALLMAN8DIR)
INSTALLSITEMAN8DIR = $(SITEPREFIX)/man/man8
DESTINSTALLSITEMAN8DIR = $(DESTDIR)$(INSTALLSITEMAN8DIR)
INSTALLVENDORMAN8DIR = $(VENDORPREFIX)/share/man/man8
DESTINSTALLVENDORMAN8DIR = $(DESTDIR)$(INSTALLVENDORMAN8DIR)
MAN8EXT = 8
SBIN_FILES = sbin/id3fsd
INST_SBINDIR = blib/sbin
INSTALLSBINDIR = $(PERLPREFIX)/sbin
DESTINSTALLSBINDIR = $(DESTDIR)$(INSTALLSBINDIR)
INSTALLSITESBINDIR = $(SITEPREFIX)/sbin
DESTINSTALLSITESBINDIR = $(DESTDIR)$(INSTALLSITESBINDIR)
INSTALLVENDORSBINDIR = $(VENDORPREFIX)/sbin
DESTINSTALLVENDORSBINDIR = $(DESTDIR)$(INSTALLVENDORSBINDIR)
# end id3fs

};

    return $inherited . $add;

}


sub MY::top_targets {

    use Config;

    my $self = shift;
    my $inherited = $self->SUPER::top_targets(@_);

    my ($perlh) = $self->catfile($Config{archlibexp}, 'CORE', "perl.h");

    my $noecho = q{NOECHO = @} unless $inherited =~ /NOECHO/;

    my $add = sprintf <<'MAKE_FRAG', $perlh, $perlh, $perlh, $perlh;

# begin id3fs
config :: $(INST_MAN8DIR)/.exists $(INST_SBINDIR)/.exists
	@$(NOOP)

$(INST_MAN8DIR)/.exists :: %s
	@$(MKPATH) $(INST_MAN8DIR)
	@$(EQUALIZE_TIMESTAMP) %s $(INST_MAN8DIR)/.exists
	-@$(CHMOD) $(PERM_RWX) $(INST_MAN8DIR)

$(INST_SBINDIR)/.exists :: %s
	@$(MKPATH) $(INST_SBINDIR)
	@$(EQUALIZE_TIMESTAMP) %s $(INST_SBINDIR)/.exists
	-@$(CHMOD) $(PERM_RWX) $(INST_SBINDIR)
	@$(CP) $(SBIN_FILES) $(INST_SBINDIR)
# end id3fs

MAKE_FRAG

    return $inherited . $add;
}


sub MY::manifypods {
    my $self = shift;
    my $inherited = $self->SUPER::manifypods(@_);

    $inherited =~ s{^(manifypods : .*)\\}{$1 manifypods-local \\}m;

    # MakeMaker 6.06_x through 6.13 eliminated the POD2MAN macro.
    my $pod2man = "";
    unless ($inherited =~ /^POD2MAN\b/m)
    {
	$pod2man=q{POD2MAN = $(POD2MAN_EXE)};
    }
    my $manifypods_local = sprintf <<'MAKE_FRAG', $pod2man;

# begin id3fs
%s

manifypods-local : sbin/id3fsd
	$(POD2MAN) -s $(MAN8EXT) sbin/id3fsd $(INST_MAN8DIR)/id3fsd.$(MAN8EXT)

#end id3fs
MAKE_FRAG

    return $inherited . "\n" . $manifypods_local;

}


sub MY::install {

  my $self = shift;
  my $inherited = $self->SUPER::install(@_);
  $inherited =~ s/(^\s*\$\(INST_)MAN3(DIR\s*.*)MAN3(DIR\))/${1}MAN3${2}MAN3${3} \\\n${1}SBIN${2}SBIN${3}/gm;
  $inherited =~ s/(^\s*\$\(INST_MAN)3(DIR\s*.*MAN)3(DIR\))/${1}3${2}3$3 \\\n${1}8${2}8$3/gm;

  return $inherited;
}

}
