# id3fs - a FUSE-based filesystem for browsing audio metadata
# Copyright (C) 2010  Ian Beckwith <ianb@erislabs.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

package ID3FS::AudioFile::Flac;

use strict;
use warnings;
use Audio::FLAC::Header;

sub new
{
    my $proto=shift;
    my $class=ref($proto) || $proto;
    my $self={};
    bless($self,$class);

    $self->{path}=shift;
    my $flac=Audio::FLAC::Header->new($self->{path});
    $self->{tags}=$flac->tags();
    return $self;
}

sub get
{
    my ($self, $tag)=@_;
    for my $key (keys %{$self->{tags}})
    {
	if($key =~ /$tag/i &&
	   defined($self->{tags}->{$key})  &&
	   length($self->{tags}->{$key})   &&
	   $self->{tags}->{$key} =~ /\S+/)
	{
	    return $self->{tags}->{$key};
	}
    }
    return undef;
}

sub artist    { shift->get("ARTIST"); }
sub album     { shift->get("ALBUM");  }
sub audiotype { return "flac";        }
sub haspic    { return undef;         } # NEXTVERSION
sub v1genre   { return undef;         } # ID3 only
sub year      { shift->get("DATE");   }

sub tags
{
    my $self=shift;
    my @tags=();
    my $tags={};
    for my $key (keys %{$self->{tags}})
    {
	if($key =~ /genre/i &&
	   defined($self->{tags}->{$key})  &&
	   length($self->{tags}->{$key})   &&
	   $self->{tags}->{$key} =~ /\S+/)
	{
	    push(@tags, $self->{tags}->{$key});
	}
    }
    return(@tags);
}

1;
