# id3fs - a FUSE-based filesystem for browsing audio metadata
# Copyright (C) 2010  Ian Beckwith <ianb@erislabs.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

package ID3FS::AudioFile::Mp3;

use strict;
use warnings;
use MP3::Tag;

sub new
{
    my $proto=shift;
    my $class=ref($proto) || $proto;
    my $self={};
    bless($self,$class);

    $self->{path}=shift;
    $self->{mp3}=MP3::Tag->new($self->{path});
    $self->get_tags();
    $self->{v1}=undef;
    $self->{v1}=$self->{mp3}->{ID3v1} if(exists($self->{mp3}->{ID3v1}));
    $self->{v2}=undef;
    $self->{v2}=$self->{mp3}->{ID3v2} if(exists($self->{mp3}->{ID3v2}));

    $self->{tags}={};

    return $self;
}

sub choose
{
    my ($self, $func)=@_;
    my $thing=undef;
    if(defined($self->{v2}))
    {
	$thing=$self->{v2}->$func();
    }
    if(defined($self->{v1}) && (!defined($thing) || !length($thing)))
    {
	$thing=$self->{v1}->$func();
    }
    return $thing;
}

sub artist    { shift->choose("artist"); }
sub album     { shift->choose("album");  }
# We don't care if year is not set
sub year      { shift->choose("year");   }
sub audiotype { return "mp3";            }
sub haspic    { return undef;            } # NEXTVERSION

sub v1genre
{
    my($self)=@_;
    my $genre=undef;
    $genre=$self->{v1}->genre() if(defined($self->{v1}));
    return $genre;
}

sub tags
{
    my $self=shift;
    return() unless(exists($self->{mp3}->{ID3v2}) && defined($self->{mp3}->{ID3v2}));
    return($self->{mp3}->{ID3v2}->genre());
}

sub get_tags
{
    my ($self)=@_;
    # MP3::Tag->get_tags shows cryptic debug info via print when it finds
    # an unhandled id3v2 version, in addition to the warning, so use
    # select to send prints to /dev/null
    my $oldout=undef;
    if(open(NULL,">/dev/null"))
    {
	$oldout=select(NULL);
    }
    eval { $self->{mp3}->get_tags; };
    warn("$self->{path}: $@\n") if($@);
    if(defined($oldout))
    {
	select($oldout);
	close(NULL);
    }
}

1;
