# id3fs - a FUSE-based filesystem for browsing audio metadata
# Copyright (C) 2010  Ian Beckwith <ianb@erislabs.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

package ID3FS::AudioFile::Ogg;

use strict;
use warnings;
use Ogg::Vorbis::Header;

sub new
{
    my $proto=shift;
    my $class=ref($proto) || $proto;
    my $self={};
    bless($self,$class);

    $self->{path}=shift;
    $self->{ogg}=Ogg::Vorbis::Header->new($self->{path});
    $self->{comments}=[ $self->{ogg}->comment_tags() ];
    return $self;
}

sub get
{
    my ($self, $tag)=@_;
    for my $commenttype (@{$self->{comments}})
    {
	if($commenttype =~ /$tag/i)
	{
	    my @comments=$self->{ogg}->comment($commenttype);
	    if(@comments)
	    {
		# take first comment with actual contents
		while(my $comment=shift @comments)
		{
		    if(defined($comment) &&
		       length($comment)  &&
		       $comment =~ /\S+/)
		    {
			$comment =~ s/\//-/g; # drop slashes
			return $comment;
		    }
		}
	    }
	}
    }
    return undef;
}

sub artist    { shift->get("Artist"); }
sub album     { shift->get("Album");  }
sub audiotype { return "ogg";         }
sub haspic    { return undef;         } # NEXTVERSION
sub v1genre   { return undef;         } # ID3 only
sub year      { shift->get("Date");   }

sub tags
{
    my $self=shift;
    my @comments;
    for my $commenttype (@{$self->{comments}})
    {
	if($commenttype =~ /genre/i)
	{
	    push(@comments,$self->{ogg}->comment($commenttype));
	}
    }
    return(@comments);
}

1;

