Summary: telnet and telnetd with START_TLS and FORWARD_X support.
Name: start_tls-telnet
Version: 20000920
Release: 1
Copyright: GPL and BSD
Packager: Peter 'Luna' Runestig <peter@runestig.com>
Group: System Environment/Daemons
Source: ftp://ftp.runestig.com/pub/starttls/start_tls-telnet.%{PACKAGE_VERSION}.tar.gz
BuildRoot: /var/tmp/start_tls-telnet-root
Requires: openssl-appl

%description
The start_tls-telnet package contains both the telnet client and the telnetd
server that supports TLS authentication and encryption (by the means of the
OpenSSL toolkit), and X Window tunneling (the FORWARD_X telnet option, an idea
by Jeffrey Altman <jaltman@columbia.edu>).

%prep
# you must have statically linked OpenSSL installed in `/usr/local/ssl'
%setup -q -n start_tls-telnet
./configure --enable-fwdx_unix_sock --with-openssl-dir=/usr/local/ssl

%build
make "LDFLAGS=-static -L/usr/local/ssl/lib"

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
strip $RPM_BUILD_ROOT/usr/local/bin/telnet
strip $RPM_BUILD_ROOT/usr/local/sbin/telnetd
mkdir -p $RPM_BUILD_ROOT/usr/local/ssl/{certs,private}

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/usr/local/bin/telnet
/usr/local/sbin/telnetd
/usr/local/man/man1/telnet.1
/usr/local/man/man8/telnetd.8
/usr/local/ssl

%post
echo "If you don't have a TLS certificate to use with telnetd,"
echo "run the following command:"
echo "# /usr/local/ssl/misc/mk_selfsigned_cert.sh telnetd-rsa.pem"
echo "A self-signed TLS certificate will be created for you."
