Name		: telnet-tls
Version		: 20010704
Release		: pr1
Group		: System/Network
Requires	: openssl
BuildRequires	: openssl-devel
Conflicts	: telnet telnet-server
Copyright	: GPL and BSD
Packager	: Peter 'Luna' Runestig <peter@runestig.com>
URL		: ftp://ftp.runestig.com/pub/telnet-tls/

Summary		: telnet and telnetd with START_TLS and FORWARD_X support.

BuildRoot	: /tmp/%{Name}-%{Version}

%define ssldir /usr/share/ssl

Source0: ftp://ftp.runestig.com/pub/telnet-tls/start_tls-telnet.%{PACKAGE_VERSION}.tar.gz
Source1: telnetd-rsa.pem
Source2: telnetd-rsa-key.pem
Source3: telnet.xinetd

%Description
The telnet-tls package contains both the telnet client and the telnetd
server that supports TLS authentication and encryption (by the means of the
OpenSSL toolkit), and X Window tunneling (the FORWARD_X telnet option, an idea
by Jeffrey Altman <jaltman@columbia.edu>).


%Prep
%setup -n start_tls-telnet


%Build
./configure --prefix=/usr --mandir=%{_mandir} --localstatedir=/var  \
	--enable-tls_sfc --enable-tls_zlib --enable-fwdx_unix_sock 
make


%Install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT

make install DESTDIR=$RPM_BUILD_ROOT
strip $RPM_BUILD_ROOT/usr/bin/telnet $RPM_BUILD_ROOT/usr/sbin/telnetd
mkdir -p $RPM_BUILD_ROOT%{ssldir}/{certs,private}
cp -p %{SOURCE1} $RPM_BUILD_ROOT%{ssldir}/certs
hash=`openssl x509 -hash -noout -in %{SOURCE1}`
ln -s `basename %{SOURCE1}` $RPM_BUILD_ROOT%{ssldir}/certs/$hash.0
cp -p %{SOURCE2} $RPM_BUILD_ROOT%{ssldir}/private
chmod 600 $RPM_BUILD_ROOT%{ssldir}/private/*
mkdir -p $RPM_BUILD_ROOT/etc/xinetd.d
cp -p %{SOURCE3} $RPM_BUILD_ROOT/etc/xinetd.d/telnet
mkdir -p $RPM_BUILD_ROOT/var/state/tls_sfc

%Clean
rm -rf $RPM_BUILD_ROOT


%Files
%defattr(-,root,root)
%doc CHANGES.TLS README.TLS README THANKS TODO ChangeLog
%config %{ssldir}/certs/*
%attr(0600,root,root) %config %{ssldir}/private/*
%config /etc/xinetd.d/telnet
/usr/bin/telnet
/usr/sbin/telnetd
%{_mandir}/man1/telnet.1*
%{_mandir}/man8/telnetd.8*
%attr(0700,root,root) %dir /var/state/tls_sfc


%ChangeLog
* Tue Nov 27 2001 Peter 'Luna' Runestig <peter@runestig.com>
- Created the whole thing, based on my earlier Caldera package. We don't like
  Caldera anymore, since their kernel config is braindamage...
