/*
 * Copyright (c) Peter 'Luna' Runestig 1999 - 2002 <peter@runestig.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LI-
 * ABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUEN-
 * TIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEV-
 * ER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABI-
 * LITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TLSUTIL_H_
#define _TLSUTIL_H_

extern char	*tls_keyfile;
extern char	*tls_certfile;
extern char	*tls_hostname;
extern char	tls_cipher_list[];
#ifdef PR_TELNET
extern int	tls_active;
extern int	tls_suspend_iacs;
extern int 	tls_reset_state;
#endif /* PR_TELNET */
#ifdef PR_OBSD_FTP
extern int	tls_on_ctrl;
extern int 	tls_on_data;
#endif /* PR_OBSD_FTP */

int	tls_init(void);
void	tls_cleanup(void);
int	tls_recv(int s, void *buf, size_t len, int flags);
int	tls_send(int s, const void *msg, size_t len, int flags);
ssize_t	tls_read(int fd, void *buf, size_t count);
ssize_t	tls_write(int fd, const void *buf, size_t count);
int	tls_fgetc(FILE *stream);
int	tls_fputc(int c, FILE *stream);
int	tls_fputs(const char *s, FILE *stream);
int	tls_fflush(FILE *stream);
int	tls_fclose( FILE *stream);
int	tls_close(int fd);
void	tls_set_cipher_list(char *list);
void	tls_set_defaults(void);
int	tls_optarg(char *optarg);
char	*tls_get_cipher_info_string(int s);
#ifdef PR_TELNET
int	tls_try(void);
void	tls_shutdown(void);
int	tls_pending(void);
#endif /* PR_TELNET */
#ifdef PR_OBSD_FTP
int	tls_connect_ctrl(int s);
int	tls_connect_data(int s);
int	tls_shutdown(int s, int how);
void	tls_free_ssls(void);
int	tls_vfprintf(FILE *stream, const char *format, va_list ap);
int	tls_active(int s);
#ifdef __STDC__
int	tls_fprintf(FILE *stream, const char *fmt, ...);
#else
int	tls_fprintf(stream, fmt, va_alist);
    FILE *stream;
    char *fmt;
    va_dcl
#endif /* !__STDC__ */
#endif /* PR_OBSD_FTP */


#endif /* !_TLSUTIL_H_ */
