/*
 * Copyright (c) 1999 - 2002 Peter 'Luna' Runestig <peter@runestig.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modifi-
 * cation, are permitted provided that the following conditions are met:
 *
 *    o Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *
 *    o Redistributions in binary form must reproduce the above copyright no-
 *      tice, this list of conditions and the following disclaimer in the do-
 *      cumentation and/or other materials provided with the distribution.
 *
 *    o The names of the contributors may not be used to endorse or promote
 *      products derived from this software without specific prior written
 *      permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LI-
 * ABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUEN-
 * TIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEV-
 * ER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABI-
 * LITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TLSUTIL_H_
#define _TLSUTIL_H_

extern int	tls_required;
extern char 	*tls_rsa_key_file;
extern char	*tls_rsa_cert_file;
extern char	*tls_rsa_cert_chain_file;
extern char 	*tls_dsa_key_file;
extern char	*tls_dsa_cert_file;
extern char	*tls_dsa_cert_chain_file;
extern char	*tls_crl_file;
extern char	*tls_dhparam_file;
extern char	*tls_cipher_list;
#ifdef PR_TELNETD
extern int	tls_active;
extern int	tls_follows_from_client;
#endif /* PR_TELNETD */
#ifdef PR_OBSD_FTPD
extern int	tls_on_ctrl;
extern int	tls_on_data;
extern int	tls_pass_passthrough;
#endif /* PR_OBSD_FTPD */
#ifdef PR_PROFTPD
extern int	tls_on_ctrl;
extern int	tls_on_data;
extern int 	tls_implicit;
extern int	tls_no_verify;
extern int	tls_dont_request_cert;
extern int	tls_init_error;
#endif /* PR_PROFTPD */

int	tls_init(void);
void	tls_set_defaults(void);
void	tls_cleanup(void);
int	tls_is_user_valid(char *user);
char	*tls_userid_from_client_cert(void);
#if defined(PR_OBSD_FTPD) || defined(PR_TELNETD)
int	tls_optarg(char *optarg);
ssize_t	tls_read(int fd, void *buf, size_t count);
ssize_t	tls_write(int fd, const void *buf, size_t count);
#elif defined(PR_PROFTPD)
ssize_t	tls_read(SSL *ssl, void *buf, size_t count);
ssize_t	tls_write(SSL *ssl, const void *buf, size_t count);
#endif
#ifdef PR_TELNETD
int	tls_accept(void);
void	tls_shutdown(void);
int	tls_recv(int s, void *buf, size_t len, int flags);
int	tls_send(int s, const void *msg, size_t len, int flags);
int	tls_pending(void);
#endif /* PR_TELNETD */
#ifdef PR_PROFTPD
int	tls_accept(conn_t *conn, int data_connection);
void	tls_close_session(SSL *ssl);
int	tls_pending(SSL *ssl);
#endif /* PR_PROFTPD */
#ifdef PR_OBSD_FTPD
int	tls_accept(int s, int dataconn);
void	tls_exit(int status);
int	tls_vfprintf(FILE *stream, const char *format, va_list ap);
int	tls_vprintf(const char *format, va_list ap);
int	tls_fflush(FILE *stream);
int	tls_fclose(FILE *stream);
int	tls_close(int fd);
int	tls_fgetc(FILE *stream);
int	tls_fputc(int c, FILE *stream);
#ifdef __STDC__
int	tls_fprintf(FILE *stream, const char *fmt, ...);
#else
int	tls_fprintf(stream, fmt, va_alist);
    FILE *stream;
    char *fmt;
    va_dcl
#endif
#ifdef __STDC__
int	tls_printf(const char *fmt, ...);
#else
int	tls_printf(fmt, va_alist);
    char *fmt;
    va_dcl
#endif
#endif /* PR_OBSD_FTPD */


#endif /* !_TLSUTIL_H_ */
